///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the PRS-related exported structures.
 *	\file		FLX_AddPRS.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDPRS_H__
#define __FLX_ADDPRS_H__

	//! A point. Redefined so that the plug-ins can be compiled without MAX or ICE.
	struct MAXPoint
	{
		MAXPoint()									{}
		MAXPoint(float _x, float _y, float _z)		{ x = _x; y = _y; z = _z; }

		union{
			struct { float x, y, z; };
			struct { float r, g, b; };
		};
	};

	//! A quaternion. Redefined so that the plug-ins can be compiled without MAX or ICE.
	struct MAXQuat
	{
		float x, y, z, w;
	};

	//! PRS = Position/Rotation/Scale. PRS data can be recovered from MAX thanks to the decomp_affine function in MAX SDK.
	struct MAXPRS
	{
		MAXPoint	Position;		//!< Translation part
		MAXQuat		Rotation;		//!< Rotation part
		MAXPoint	Scale;			//!< Scale part
	};

#endif // __FLX_ADDPRS_H__
